/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastScrollButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class FastScrollBarUI
extends BaseScrollBarUI {
    public static ComponentUI createUI(JComponent c2) {
        return new FastScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new FastScrollButton(orientation, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new FastScrollButton(orientation, this.scrollBarWidth);
    }

    protected void paintTrack(Graphics g2, JComponent c2, Rectangle trackBounds) {
        g2.setColor(AbstractLookAndFeel.getControlColorLight());
        g2.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        g2.translate(thumbBounds.x, thumbBounds.y);
        Color backColor = AbstractLookAndFeel.getTheme().getControlBackgroundColor();
        if (!JTattooUtilities.isActive(c2)) {
            backColor = ColorHelper.brighter(backColor, 50.0);
        }
        Color frameColorHi = ColorHelper.brighter(backColor, 40.0);
        Color frameColorLo = ColorHelper.darker(backColor, 30.0);
        g2.setColor(backColor);
        g2.fillRect(1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
        g2.setColor(frameColorLo);
        g2.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 1);
        g2.setColor(frameColorHi);
        g2.drawLine(1, 1, thumbBounds.width - 2, 1);
        g2.drawLine(1, 1, 1, thumbBounds.height - 2);
        g2.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

